<?php
// ini_set('display_errors','1');
// error_reporting(E_ALL);
include("../function/func.php");
session_start();
checkSession();
$page = "main";
if ($_REQUEST['id']) {
    $orderInfo = getOrderDetail($_REQUEST['id']);
    $signs0 = getSigns($_REQUEST['id'], 0);
    $signs1 = getSigns($_REQUEST['id'], 1);
    $signs2 = getSigns($_REQUEST['id'], 2);
    $signs3 = getSigns($_REQUEST['id'], 3);
    $testType = "normal";
    $testItems = getOrderTestList($_REQUEST['id']);
    //拉拔測試
    $hasPSI = false;
    if (count($testItems) == 0) {
        $testType = "pullTest";
        $ordersId = getOrderIDFromID($_REQUEST['id']);
        $testItems = getOrderPullTestList($ordersId);
        // 看有沒有設計規範值
        $hasDesignKgf = false;
        foreach ($testItems as $item) {
            if ($item['designLoadKgf'] > 0) {
                $hasDesignKgf = true;
            }
            if ($item['type'] != '0' && $item['type'] != '') {
                $item['type'] = "TYPE_" . $item['type'];
            }
        }

        for ($pp = 0; $pp < count($testItems); $pp++) {
            if ($testItems[$pp]['pressureValue'] > 500) {
                $hasPSI = true;
            }
        }
    }
    /** PHPExcel */
    require_once "../PHPExcel/Classes/PHPExcel.php";
    /** PHPExcel_IOFactory */
    require_once "../PHPExcel/Classes/PHPExcel/IOFactory.php";
    // 建立工作表並指定名稱
    $index = 0;
    $objPHPExcel = new PHPExcel();

    $objPHPExcel->setActiveSheetIndex($index); //設定預設顯示的工作表


    $objPHPExcel->getActiveSheet()->setTitle("報表"); // 重新命名 sheet 名稱
    setImageLogo($objPHPExcel, "A1");
    if ($testType == "normal") {
        $objPHPExcel->getActiveSheet()->setCellValue('C1', "以拉脫法測試混凝土表面抗拉強度暨");
        $objPHPExcel->getActiveSheet()->setCellValue('C2', "混凝土修補及覆層材料黏著或抗拉強度");
        $objPHPExcel->getActiveSheet()->getStyle("C1")->getFont()->setSize(18)->setName('標楷體');
        $objPHPExcel->getActiveSheet()->getRowDimension(1)->setRowHeight(25);
        $objPHPExcel->getActiveSheet()->getStyle("C2")->getFont()->setSize(18)->setName('標楷體');
    } else {
        $cellRange = 'A2:G2'; // 列A到列G的范围
        $objPHPExcel->getActiveSheet()->mergeCells($cellRange);

        $objPHPExcel->getActiveSheet()->getStyle("A2")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->setCellValue('A2', $testItems[0][testTypeName]);
        $objPHPExcel->getActiveSheet()->getStyle("A2")->getFont()->setSize(24)->setName('標楷體');
        $objPHPExcel->getActiveSheet()->getRowDimension("A2")->setRowHeight(25);
    }
    //
    $cellRange = 'B7:E7'; // 列A到列G的范围
    $objPHPExcel->getActiveSheet()->mergeCells($cellRange);
    $cellRange = 'B8:E8'; // 列A到列G的范围
    $objPHPExcel->getActiveSheet()->mergeCells($cellRange);
    $cellRange = 'B9:E9'; // 列A到列G的范围
    $objPHPExcel->getActiveSheet()->mergeCells($cellRange);
    $cellRange = 'B10:E10'; // 列A到列G的范围
    $objPHPExcel->getActiveSheet()->mergeCells($cellRange);
    $cellRange = 'B11:G11'; // 列A到列G的范围
    $objPHPExcel->getActiveSheet()->mergeCells($cellRange);
    $cellRange = 'B12:G12'; // 列A到列G的范围
    $objPHPExcel->getActiveSheet()->mergeCells($cellRange);
    $cellRange = 'B13:G13'; // 列A到列G的范围
    $objPHPExcel->getActiveSheet()->mergeCells($cellRange);
    $cellRange = 'B14:G14'; // 列A到列G的范围
    $objPHPExcel->getActiveSheet()->mergeCells($cellRange);
    $cellRange = 'B15:G15'; // 列A到列G的范围
    $objPHPExcel->getActiveSheet()->mergeCells($cellRange);
   

    $objPHPExcel->getActiveSheet()->setCellValue('A5', "桂田技術顧問有限公司 桂田台北實驗室");
    $objPHPExcel->getActiveSheet()->setCellValue('A6', "新北市深坑區北深路二段136巷15-3號 電話: (02)6637-8009 傳真:(02)2664-7513");
    $objPHPExcel->getActiveSheet()->getStyle("A5")->getFont()->setSize(9)->setName('標楷體');
    $objPHPExcel->getActiveSheet()->getStyle("A6")->getFont()->setSize(9)->setName('標楷體');
    $objPHPExcel->getActiveSheet()->getStyle("A5")->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER); //垂直置中
    $objPHPExcel->getActiveSheet()->getStyle("A6")->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER); //垂直置中
    $objPHPExcel->getActiveSheet()->setCellValue('A7', "工程名稱:");
    $objPHPExcel->getActiveSheet()->getCell("B7")->setValueExplicit($orderInfo[0]['projectName'], PHPExcel_Cell_DataType::TYPE_STRING);
    $objPHPExcel->getActiveSheet()->getStyle('B7')->getAlignment()->setWrapText(true);
    if(mb_strlen($orderInfo[0]['projectName'])>28){
        $objPHPExcel->getActiveSheet()->getRowDimension('7')->setRowHeight(34.5);
    }
    $objPHPExcel->getActiveSheet()->setCellValue('A8', "委託單位:");
    $objPHPExcel->getActiveSheet()->getCell("B8")->setValueExplicit($orderInfo[0]['applicantName'], PHPExcel_Cell_DataType::TYPE_STRING);
    $objPHPExcel->getActiveSheet()->getStyle('B8')->getAlignment()->setWrapText(true);
    if(mb_strlen($orderInfo[0]['applicantName'])>28){
        $objPHPExcel->getActiveSheet()->getRowDimension('8')->setRowHeight(34.5);
    }
    $objPHPExcel->getActiveSheet()->setCellValue('A9', "業    主:");
    $objPHPExcel->getActiveSheet()->getCell("B9")->setValueExplicit($orderInfo[0]['businessOwner'], PHPExcel_Cell_DataType::TYPE_STRING);
    $objPHPExcel->getActiveSheet()->getStyle('B9')->getAlignment()->setWrapText(true);
    if(mb_strlen($orderInfo[0]['businessOwner'])>28){
        $objPHPExcel->getActiveSheet()->getRowDimension('9')->setRowHeight(34.5);
    }
    $objPHPExcel->getActiveSheet()->setCellValue('A10', "監造單位:");
    $objPHPExcel->getActiveSheet()->getCell("B10")->setValueExplicit($orderInfo[0]['supervisor'], PHPExcel_Cell_DataType::TYPE_STRING);
    $objPHPExcel->getActiveSheet()->getStyle('B10')->getAlignment()->setWrapText(true);
    if(mb_strlen($orderInfo[0]['supervisor'])>28){
        $objPHPExcel->getActiveSheet()->getRowDimension('10')->setRowHeight(34.5);
    }
    $objPHPExcel->getActiveSheet()->setCellValue('A11', "承 包 商:");
    $objPHPExcel->getActiveSheet()->getCell("B11")->setValueExplicit($orderInfo[0]['contractor'], PHPExcel_Cell_DataType::TYPE_STRING);
    $objPHPExcel->getActiveSheet()->getStyle('B11')->getAlignment()->setWrapText(true);
    if(mb_strlen($orderInfo[0]['contractor'])>getWidthCount($orderInfo[0]['contractor'])){
        $objPHPExcel->getActiveSheet()->getRowDimension('11')->setRowHeight(34.5);
    }
    $objPHPExcel->getActiveSheet()->setCellValue('A12', "取樣人員:");
    $objPHPExcel->getActiveSheet()->getCell("B12")->setValueExplicit($orderInfo[0]['sampler'], PHPExcel_Cell_DataType::TYPE_STRING);
    $objPHPExcel->getActiveSheet()->getStyle('B12')->getAlignment()->setWrapText(true);
    if(mb_strlen($orderInfo[0]['sampler'])>getWidthCount($orderInfo[0]['sampler'])){
        $objPHPExcel->getActiveSheet()->getRowDimension('12')->setRowHeight(34.5);
    }
    $objPHPExcel->getActiveSheet()->setCellValue('A13', "會驗人員:");
    $objPHPExcel->getActiveSheet()->getCell("B13")->setValueExplicit($orderInfo[0]['examinator'], PHPExcel_Cell_DataType::TYPE_STRING);
    $objPHPExcel->getActiveSheet()->getStyle('B13')->getAlignment()->setWrapText(true);
    if(mb_strlen($orderInfo[0]['examinator'])>getWidthCount($orderInfo[0]['examinator'])){
        $objPHPExcel->getActiveSheet()->getRowDimension('13')->setRowHeight(34.5);
    }
    $objPHPExcel->getActiveSheet()->setCellValue('A14', "結構部位:");
    $objPHPExcel->getActiveSheet()->getCell("B14")->setValueExplicit($orderInfo[0]['structuralPart'], PHPExcel_Cell_DataType::TYPE_STRING);
    $objPHPExcel->getActiveSheet()->getStyle('B14')->getAlignment()->setWrapText(true);
    if(mb_strlen($orderInfo[0]['structuralPart'])>getWidthCount($orderInfo[0]['structuralPart'])){
        $objPHPExcel->getActiveSheet()->getRowDimension('14')->setRowHeight(34.5);
    }
    $objPHPExcel->getActiveSheet()->setCellValue('A15', "材料名稱:");
    $objPHPExcel->getActiveSheet()->getCell("B15")->setValueExplicit($orderInfo[0]['materialsName'], PHPExcel_Cell_DataType::TYPE_STRING);
    $objPHPExcel->getActiveSheet()->getStyle('B15')->getAlignment()->setWrapText(true);
    
    if(mb_strlen($orderInfo[0]['materialsName'])>getWidthCount($orderInfo[0]['materialsName'])){
        $objPHPExcel->getActiveSheet()->getRowDimension('15')->setRowHeight(34.5);
    }
    //$phpColor = new PHPExcel_Style_Color();
    //$phpColor->setRGB('FF0000');
    //for($i=7;$i<17;$i++){
    //$objPHPExcel->getActiveSheet()->getStyle("A".$i)->getFont()->setColor($phpColor)->setSize(12)->setName('標楷體');
    //}
    if ($testType == 'normal') {
        $objPHPExcel->getActiveSheet()->setCellValue('F7', "報告編號:");
        $objPHPExcel->getActiveSheet()->getCell("G7")->setValueExplicit($orderInfo[0]['orderID'], PHPExcel_Cell_DataType::TYPE_STRING);
        //$objPHPExcel->getActiveSheet()->setCellValue('F8', "頁    次:");
        //$objPHPExcel->getActiveSheet()->setCellValue('G8', "第 1 頁，共 1頁");
        //報告日期
        $objPHPExcel->getActiveSheet()->setCellValue('F8', "報告日期:");
        $insertDate = substr($orderInfo[0]['insertDate'], 0, 4) . "年" . substr($orderInfo[0]['insertDate'], 5, 2) . "月" . substr($orderInfo[0]['insertDate'], 8, 2) . "日";
        $objPHPExcel->getActiveSheet()->getCell("G8")->setValueExplicit($insertDate, PHPExcel_Cell_DataType::TYPE_STRING);
        //試驗時間
        $objPHPExcel->getActiveSheet()->setCellValue('F9', "試驗日期:   ");
        $testDate = substr($orderInfo[0]['testDate'], 0, 4) . "年" . substr($orderInfo[0]['testDate'], 5, 2) . "月" . substr($orderInfo[0]['testDate'], 8, 2) . "日";
        $objPHPExcel->getActiveSheet()->getCell("G9")->setValueExplicit($testDate, PHPExcel_Cell_DataType::TYPE_STRING);
        //製作日期
        if ($testType == 'normal') {
            $objPHPExcel->getActiveSheet()->setCellValue('F10', "製作日期:");
            if($orderInfo[0]['productionDate']!=""){
                $productionDate = substr($orderInfo[0]['productionDate'], 0, 4) . "年" . substr($orderInfo[0]['productionDate'], 5, 2) . "月" . substr($orderInfo[0]['productionDate'], 8, 2) . "日";
            }
            $objPHPExcel->getActiveSheet()->getCell("G10")->setValueExplicit($productionDate, PHPExcel_Cell_DataType::TYPE_STRING);
        }
    } else {
        $objPHPExcel->getActiveSheet()->setCellValue('F7', "報告編號:");
        $objPHPExcel->getActiveSheet()->getCell("G7")->setValueExplicit($orderInfo[0]['orderID'], PHPExcel_Cell_DataType::TYPE_STRING);

        //$objPHPExcel->getActiveSheet()->setCellValue('F8', "頁    次:");
        //$objPHPExcel->getActiveSheet()->setCellValue('G8', "第 1 頁，共 1頁");
        //報告日期
        $objPHPExcel->getActiveSheet()->setCellValue('F8', "報告日期:");
        $insertDate = substr($orderInfo[0]['insertDate'], 0, 4) . "年" . substr($orderInfo[0]['insertDate'], 5, 2) . "月" . substr($orderInfo[0]['insertDate'], 8, 2) . "日";
        $objPHPExcel->getActiveSheet()->getCell("G8")->setValueExplicit($insertDate, PHPExcel_Cell_DataType::TYPE_STRING);
        //試驗時間
        $objPHPExcel->getActiveSheet()->setCellValue('F9', "試驗日期:   ");
        $testDate = substr($orderInfo[0]['testDate'], 0, 4) . "年" . substr($orderInfo[0]['testDate'], 5, 2) . "月" . substr($orderInfo[0]['testDate'], 8, 2) . "日";
        $objPHPExcel->getActiveSheet()->getCell("G9")->setValueExplicit($testDate, PHPExcel_Cell_DataType::TYPE_STRING);
        //製作日期
        if ($testType == 'normal') {
            $objPHPExcel->getActiveSheet()->setCellValue('F10', "製作日期:");
            if($orderInfo[0]['productionDate']!=""){
                $productionDate = substr($orderInfo[0]['productionDate'], 0, 4) . "年" . substr($orderInfo[0]['productionDate'], 5, 2) . "月" . substr($orderInfo[0]['productionDate'], 8, 2) . "日";
            }
            $objPHPExcel->getActiveSheet()->getCell("G10")->setValueExplicit($productionDate, PHPExcel_Cell_DataType::TYPE_STRING);
        }
    }


    $objPHPExcel->getActiveSheet()->setCellValue('A18', "備    註:");
    $objPHPExcel->getActiveSheet()->getCell("B18")->setValueExplicit($orderInfo[0]['remark'], PHPExcel_Cell_DataType::TYPE_STRING);
    $objPHPExcel->getActiveSheet()->getStyle('B18')->getAlignment()->setWrapText(true);
    if(mb_strlen($orderInfo[0]['remark'])>28){
        $objPHPExcel->getActiveSheet()->getRowDimension('18')->setRowHeight(34.5);
    }
    $objPHPExcel->getActiveSheet()->setCellValue('A16', "試驗儀器:");
    //if (strpos($a, 'are') !== false) {
    /*
    if(substr($orderInfo[0]['equipUsed'],0,3) == "Pro"){
        $objPHPExcel->getActiveSheet()->setCellValue('B16', "拉拔測試器   廠牌：proceq  型號： DY-216 序號：DT02-004-0074");
    }else{
        $objPHPExcel->getActiveSheet()->setCellValue('B16', "拉拔測試器   SANKO TECHNO 型號:RT-3000LD 序號:A69005");
    }*/
    if ($testType == 'normal') {
        $objPHPExcel->getActiveSheet()->setCellValue('A19', "樣品\測試值");
        $objPHPExcel->getActiveSheet()->setCellValue('B19', "抗拉荷重");
        $objPHPExcel->getActiveSheet()->setCellValue('B20', "KN");
        $objPHPExcel->getActiveSheet()->setCellValue('C19', "抗拉荷重");
        $objPHPExcel->getActiveSheet()->setCellValue('C20', "kgf");
        $objPHPExcel->getActiveSheet()->setCellValue('D19', "樣品尺寸");
        $objPHPExcel->getActiveSheet()->setCellValue('D20', "長(cm)X寬(cm)");
        $objPHPExcel->getActiveSheet()->setCellValue('E19', "實際斷面積");
        $objPHPExcel->getActiveSheet()->setCellValue('E20', "面積(cm2)");
        $objPHPExcel->getActiveSheet()->setCellValue('F19', "抗拉強度");
        $objPHPExcel->getActiveSheet()->setCellValue('F20', "kgf/cm2 (Mpa)");
        $objPHPExcel->getActiveSheet()->setCellValue('G19', "破壞位置");
        //測試資料
        for ($i = 0; $i < count($testItems); $i++) {
            $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i), $testItems[$i]['testLocat']);
            $objPHPExcel->getActiveSheet()->getStyle('A' . (22 + $i))->getAlignment()->setWrapText(true);
            $lineNum = round(mb_strlen($testItems[$i]['testLocat'], 'utf8') / 6);
            //$lineNum=mb_strlen($testItems[0]['testLocat'],'utf8');
            if ($lineNum > 1) {
                $objPHPExcel->getActiveSheet()->getRowDimension(22 + $i)->setRowHeight(80);
            }

            //$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(12);
            $objPHPExcel->getActiveSheet()->setCellValue('B' . (22 + $i), $testItems[$i]['kN']);
            $objPHPExcel->getActiveSheet()->setCellValue('C' . (22 + $i), $testItems[$i]['kgf']);
            $objPHPExcel->getActiveSheet()->setCellValue('D' . (22 + $i), $testItems[$i]['length'] . "x" . $testItems[$i]['width']);
            $objPHPExcel->getActiveSheet()->setCellValue('E' . (22 + $i), $testItems[$i]['area']);
            $objPHPExcel->getActiveSheet()->setCellValue('F' . (22 + $i), $testItems[$i]['strengthKGF'] . "(" . $testItems[$i]['strengthMPa'] . ")");
            $objPHPExcel->getActiveSheet()->setCellValue('G' . (22 + $i), $testItems[$i]['destructionLocat']);
        }
    } else {
        $objPHPExcel->getActiveSheet()->setCellValue('A19', "樣品/測試值/項目");
        if ($hasDesignKgf) {
            // $objPHPExcel->getActiveSheet()->setCellValue('A19', "壓力表值");
            // $objPHPExcel->getActiveSheet()->setCellValue('A20', "psi");
            // $objPHPExcel->getActiveSheet()->setCellValue('B19', "測試荷重");
            // $objPHPExcel->getActiveSheet()->setCellValue('B20', "kgf");
            // $objPHPExcel->getActiveSheet()->setCellValue('C19', "設計規範值");
            // $objPHPExcel->getActiveSheet()->setCellValue('C20', "kgf");
            // $objPHPExcel->getActiveSheet()->setCellValue('D19', "破壞位置");
            // $objPHPExcel->getActiveSheet()->setCellValue('D20', "");
            if ($hasPSI) {
                $objPHPExcel->getActiveSheet()->setCellValue('D19', "壓力表值");
                $objPHPExcel->getActiveSheet()->setCellValue('D20', "psi");
            }

            $objPHPExcel->getActiveSheet()->setCellValue('E19', "測試荷重");
            $objPHPExcel->getActiveSheet()->setCellValue('E20', "kgf");
            $objPHPExcel->getActiveSheet()->setCellValue('F19', "設計規範值");
            $objPHPExcel->getActiveSheet()->setCellValue('F20', "kgf");
            $objPHPExcel->getActiveSheet()->setCellValue('G19', "破壞位置");
            $objPHPExcel->getActiveSheet()->setCellValue('G20', "");
        } else {

            if ($hasPSI) {
                $objPHPExcel->getActiveSheet()->setCellValue('D19', "壓力表值");
                $objPHPExcel->getActiveSheet()->setCellValue('D20', "psi");
            }

            $objPHPExcel->getActiveSheet()->setCellValue('E19', "測試荷重");
            $objPHPExcel->getActiveSheet()->setCellValue('E20', "kgf");
            $objPHPExcel->getActiveSheet()->setCellValue('F19', "破壞位置");
            $objPHPExcel->getActiveSheet()->setCellValue('F20', "");
        }

        //$objPHPExcel->getActiveSheet()->setCellValue('G19', "備註");
        //測試資料
        for ($i = 0; $i < count($testItems); $i++) {
            $theName = "";
            if ($testItems[$i]['type'] != "") {
                $theName = "TYPE-" . $testItems[$i]['type'];
            }
            if ($testItems[$i]['info'] != "") {
                $theName .= "-" . $testItems[$i]['info'];
            }
            if ($testItems[$i]['direction'] != "") {
                $theName .= "-" . $testItems[$i]['direction'];
            }
            if ($testItems[$i]['formOfForce'] != "") {
                $theName .= "-" . $testItems[$i]['formOfForce'];
            }
            if ($testItems[$i]['forcePercentage'] != "") {
                $theName .= "-" . $testItems[$i]['forcePercentage'];
            }
            if ($hasDesignKgf) {

                $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i), $theName);
                $objPHPExcel->getActiveSheet()->setCellValue('D' . (22 + $i), $testItems[$i]['pressureValue']);
                $objPHPExcel->getActiveSheet()->setCellValue('E' . (22 + $i), round($testItems[$i]['loadKgf']));
                $objPHPExcel->getActiveSheet()->setCellValue('F' . (22 + $i), $testItems[$i]['designLoadKgf']);
                $objPHPExcel->getActiveSheet()->setCellValue('G' . (22 + $i), $testItems[$i]['destoryLocation']);
            } else {

                $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i), $theName);
                $objPHPExcel->getActiveSheet()->setCellValue('D' . (22 + $i), $testItems[$i]['pressureValue']);
                $objPHPExcel->getActiveSheet()->setCellValue('E' . (22 + $i), round($testItems[$i]['loadKgf']));
                $objPHPExcel->getActiveSheet()->setCellValue('F' . (22 + $i), $testItems[$i]['destoryLocation']);
            }
        }
    }


    //條款
    if ($testType == 'normal') {
        //抄app A:破壞於基材\nB:破壞於基材與受測材料之界面\nC:破壞於受測材料\nD:破壞於瓷磚與受測材料之黏著界面\nE:破壞於瓷磚
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 1), "A:破壞於基材。B:破壞於基材與受測材料之界面。C:破壞於受測材料。");
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 2), "D:破壞於瓷磚與受測材料之黏著界面。E:破壞於瓷磚。");
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 3), "附註:");
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 4), "(1)本試驗報告所列記錄僅對樣品負責。");
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 5), "(2)工程名稱、委託單位、聯絡資訊、業主、監造單位、承包商、取樣人員、結構部位、備註之資訊");
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 6), "由送樣單位所提供，實驗室不負責資訊之真偽。");
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 7), "(3)本報告若因客戶要求提供規範值時，該規範值僅供參考，合格之判定依權責單位為主。");
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 8), "(4)試驗報告僅提供委託單位使用，不作為法律訴訟或商業廣告之用途。");
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 9), "(5)當試驗送驗單(報告)需修改時，需經由委託單位或會送驗單位/人員提出，經送驗單位/人員之同意，");
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 10), "依試驗送驗單(報告)修改申請單進行修改。");
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 11), "(6)本測試係參考CNS 16111 A3459(108)標準施行。");
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 12), "(7)本報告未蓋鋼印無效,並不得塗改及摘錄複製。");
        if (substr($orderInfo[0]['equipUsed'], 0, 3) == "Pro") {
            $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 13), "(8)試驗儀器: 拉拔測試器 廠牌:proceq  型號:DY-216 序號:DT02-004-0074");
        } else {
            $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 13), "(8)試驗儀器: 拉拔測試器 廠牌:SANKO TECHNO 型號:RT-3000LD 序號:A69005");
        }
        //  $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 15), "報告簽署人：");
        $cell = 'A' . (22 + $i + 15);
        $objPHPExcel->getActiveSheet()->setCellValue($cell, "報告簽署人：");
        $objPHPExcel->getActiveSheet()->getStyle($cell)->getFont()->setSize(14)->setName('標楷體');
    } else {
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 1), "附註:");
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 2), "(1)本試驗報告所列記錄僅對樣品負責。");
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 3), "(2)工程名稱、委託單位、聯絡資訊、業主、監造單位、承包商、取樣人員、結構部位、備註之資訊");
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 4), "由送樣單位所提供，實驗室不負責資訊之真偽。");
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 5), "(3)本報告若因客戶要求提供規範值時，該規範值僅供參考，合格之判定依權責單位為主。");
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 6), "(4)試驗報告僅提供委託單位使用，不作為法律訴訟或商業廣告之用途。");
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 7), "(5)當試驗送驗單(報告)需修改時，需經由委託單位或會送驗單位/人員提出，經送驗單位/人員之");
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 8), "同意，依試驗送驗單(報告)修改申請單進行修改。");
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 9), "(6)本測試係參考CNS 13975 A3370施行。");
        $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + 10), "(7)本報告未蓋鋼印無效,並不得塗改及摘錄複製。");
        $allEquipment = array();
        $equipments = '';

        for ($z = 0; $z < count($testItems); $z++) {
            if (!in_array($testItems[$z]['equipment'], $allEquipment)) {
                $allEquipment[] = $testItems[$z]['equipment'];
            }
        }

        for ($z = 0; $z < count($allEquipment); $z++) {
            $equipments .= $allEquipment[$z] . '、';
        }
        $equipments = mb_substr($equipments, 0, -1, 'UTF-8');
        for ($z = 0; $z < count($allEquipment); $z++) {
            if ($z == 0) {
                $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + $z + 11), "(8)試驗儀器:" . $allEquipment[$z]);
            } else {
                $objPHPExcel->getActiveSheet()->setCellValue('A' . (22 + $i + $z + 11), $allEquipment[$z]);
            }
        }
        $cell = 'A' . (22 + $i + count($allEquipment) + 12);
        $objPHPExcel->getActiveSheet()->setCellValue($cell, "報告簽署人：");
        $objPHPExcel->getActiveSheet()->getStyle($cell)->getFont()->setSize(14)->setName('標楷體');
    }



    //設定欄寬
    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(11);
    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(9);

    if ($testType == 'normal') {
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(13);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(8);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
    } else {
        if ($hasDesignKgf) {
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(11);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
        } else {
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
        }
    }
    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(11);
    $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(11);
    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
    if ($testType == 'normal') {
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(13);
    }
    $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(16);
    $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(12);
    $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(12);
    $BStyle = array(
        'borders' => array(
            'outline' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN
            )
        ),
        'font' => array(
            'name' => '標楷體',
            'size' => '12'
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER
        )
    );
    $BStyleCenter = array(
        'borders' => array(
            'outline' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN
            )
        ),
        'font' => array(
            'name' => '標楷體',
            'size' => '12'
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER
        )
    );
    $StyleCenter = array(
        'font' => array(
            'name' => '標楷體',
            'size' => '12'
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER
        )
    );
    $StyleLeft = array(
        'font' => array(
            'name' => '標楷體',
            'size' => '12'
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER
        )
    );
    $BStyleRemark = array(

        'font' => array(
            'name' => '標楷體',
            'size' => '10'
        )
    );
    $BStyleSign = array(

        'font' => array(
            'name' => '標楷體',
            'size' => '12'
        )
    );
    $smallerFontForHeader = array(
        'font' => array(
            'name' => '標楷體',
            'size' => '11'
        )
    );
    $verySmallFontForHeader = array(
        'font' => array(
            'name' => '標楷體',
            'size' => '10'
        )
    );
    $smallerFontCenter = array(
        'font' => array(
            'name' => '標楷體',
            'size' => '11'
        )
    );
    $smallerFontLeft = array(
        'font' => array(
            'name' => '標楷體',
            'size' => '11'
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER
        )
    );
    $testItemNameStyle = array(

        'font' => array(
            'name' => '標楷體',
            'size' => '9'
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER
        )
    );
    //合併儲存格
    if ($testType == 'normal') {
        $objPHPExcel->getActiveSheet()->mergeCells('A19:A21');
    }
    
    $objPHPExcel->getActiveSheet()->mergeCells('B17:G17');
    //設定外匡與文字格式
    $objPHPExcel->getActiveSheet()->getStyle('A7:A18')->applyFromArray($StyleLeft);
    $objPHPExcel->getActiveSheet()->getStyle('B7:B18')->applyFromArray($StyleLeft);
    $objPHPExcel->getActiveSheet()->getStyle('B16:G16')->applyFromArray($BStyle);
    $objPHPExcel->getActiveSheet()->getStyle('A19:G21')->applyFromArray($BStyleCenter);
    $objPHPExcel->getActiveSheet()->getStyle('B19:F20')->applyFromArray($smallerFontForHeader);
    $objPHPExcel->getActiveSheet()->getStyle('D20:F20')->applyFromArray($verySmallFontForHeader);
    //備註
    $objPHPExcel->getActiveSheet()->getStyle('A' . (22 + $i + 1) . ":A" . (22 + $i + 13))->applyFromArray($BStyleRemark);
    //簽署人
    //$objPHPExcel->getActiveSheet()->getStyle('A'.(22+$i+13))->applyFromArray($BStyleSign);

    //$phpColor = new PHPExcel_Style_Color();
    //$phpColor->setRGB('0000FF');
    //$objPHPExcel->getActiveSheet()->getStyle('A'.(22+$i+14))->getFont()->setColor($phpColor)->setSize(14)->setName('標楷體')->setBold(true);
    $objPHPExcel->getActiveSheet()->getStyle('A' . (22 + $i + 14))->getFont()->setSize(12)->setName('標楷體')->setBold(true);

    $range = 'A22:G' . (22 + count($testItems));
    $objPHPExcel->getActiveSheet()->getStyle($range)->applyFromArray($BStyleCenter);
    $objPHPExcel->getActiveSheet()->getRowDimension(16)->setVisible(false);
    $objPHPExcel->getActiveSheet()->getRowDimension(17)->setVisible(false);


    for ($i = 5; $i < 6; $i++) {
        $objPHPExcel->getActiveSheet()->getRowDimension($i)->setRowHeight(20);
    }
    $styleArray = array(
        'font' => array(
            'name' => '標楷體',
            'size' => '12'
        ),
        'alignment' => array(
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER
        )
    );

    $objPHPExcel->getDefaultStyle()
        ->applyFromArray($styleArray);
    //if(count($testItems)<16){
        // $objPHPExcel->getActiveSheet()
        //     ->getPageSetup()
        //     ->setPrintArea('A1:G71');
    //}
    

    $objPHPExcel->getActiveSheet()
        ->getPageMargins()->setTop(0.5);
    $objPHPExcel->getActiveSheet()
        ->getPageMargins()->setRight(0.5);
    $objPHPExcel->getActiveSheet()
        ->getPageMargins()->setLeft(0.5);
    $objPHPExcel->getActiveSheet()
        ->getPageMargins()->setBottom(0.5);
    $objPHPExcel->getActiveSheet()->getPageSetup()->setFitToWidth(1);
    //測試項目
    if ($testType == "pullTest") {
        for ($i = 0; $i < count($testItems); $i++) {
            $objPHPExcel->getActiveSheet()->getStyle('F' . (22 + $i))->getFont()->setSize(12);
            $objPHPExcel->getActiveSheet()->getStyle('A' . (22 + $i))->getFont()->setSize(9);
            $objPHPExcel->getActiveSheet()->mergeCells('A' . (22 + $i) . ':' . 'C' . (22 + $i));
            $objPHPExcel->getActiveSheet()->getStyle('A' . (22 + $i))->applyFromArray($testItemNameStyle);
        }
        $objPHPExcel->getActiveSheet()->getStyle('G7')->applyFromArray($smallerFontLeft);
        $objPHPExcel->getActiveSheet()->getStyle('A19')->applyFromArray($smallerFontLeft);

        $cell = 'A' . (22 + $i + count($allEquipment) + 12);
        $objPHPExcel->getActiveSheet()->setCellValue($cell, "報告簽署人：");
        $objPHPExcel->getActiveSheet()->getStyle($cell)->getFont()->setSize(14)->setName('標楷體');
    }
    //設定g7,g8,g9的文字大小為11
    $objPHPExcel->getActiveSheet()->getStyle('G7')->getFont()->setSize(10);
    $objPHPExcel->getActiveSheet()->getStyle('G8')->getFont()->setSize(10);
    $objPHPExcel->getActiveSheet()->getStyle('G9')->getFont()->setSize(10);
    $cellRange = 'B18:G18'; // 列A到列G的范围
    $objPHPExcel->getActiveSheet()->mergeCells($cellRange);
    $objPHPExcel->getActiveSheet()->getPageSetup()->setFitToWidth(1);
    //$objPHPExcel->getActiveSheet()->getPageSetup()->setRowsToRepeatAtBottomByStartAndEnd(1, 1);
    $objPHPExcel->getActiveSheet()
    ->getHeaderFooter()->setOddFooter('&C 第&P頁，共&N頁 ');
    $objPHPExcel->getActiveSheet()
        ->getHeaderFooter()->setEvenFooter('&C 第&P頁，共&N頁 ');
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
    $orderID = getOrderIDFromID($_REQUEST['id']);
    $fileName = $orderID . ".xlsx";
    $filePath = "reports/" . $fileName;
    $objWriter->save($filePath);

}
function setImageLogo($objPHPExcel, $position)
{
    $objDrawing = new PHPExcel_Worksheet_Drawing();
    $objDrawing->setName('logo');
    $objDrawing->setDescription('logo');
    $objDrawing->setPath('image/logo_report2.png');
    $objDrawing->setCoordinates($position);
    //setOffsetX works properly
    $objDrawing->setOffsetX(8);
    //$objDrawing->setOffsetY(8);                
    //set width, height
    $objDrawing->setWidth(75);
    $objDrawing->setHeight(75);
    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());
}
function getWidthCount($str){
    return 40;
}
function setImage($objPHPExcel, $fileName, $position)
{
    $objDrawing = new PHPExcel_Worksheet_Drawing();
    $objDrawing->setName('test_img');
    $objDrawing->setDescription('test_img');
    $outputfileName = "sign.jpg";

    //$newFileName=pngToJpeg('../signPics/'.$outputfileName);
    //echo $outputfileName;
    $objDrawing->setPath('../signPics/' . $fileName);
    //$objDrawing->setPath('../signPics/4249_1.png');
    $objDrawing->setCoordinates($position);
    //setOffsetX works properly
    $objDrawing->setOffsetX(25);
    $objDrawing->setOffsetY(25);
    //set width, height
    //$objDrawing->setWidth(400); 
    //$objDrawing->setHeight(150);
    $objDrawing->setWidth(350);
    $objDrawing->setHeight(131);
    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());
}
function pngToJpeg($filePath)
{
    $image = imagecreatefrompng($filePath);
    $bg = imagecreatetruecolor(imagesx($image), imagesy($image));
    imagefill($bg, 0, 0, imagecolorallocate($bg, 255, 255, 255));
    imagealphablending($bg, TRUE);
    imagecopy($bg, $image, 0, 0, 0, 0, imagesx($image), imagesy($image));
    imagedestroy($image);
    $quality = 50; // 0 = worst / smaller file, 100 = better / bigger file

    imagejpeg($bg, $outputfileName, $quality);
    imagedestroy($bg);
    return $outputfileName;
}
function cellColor($cells, $color)
{
    global $objPHPExcel;

    $objPHPExcel->getActiveSheet()->getStyle($cells)->getFill()->applyFromArray(
        array(
            'font' => array('size' => 20),
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'startcolor' => array('rgb' => $color),
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('rgb' => '000000')
                )
            )

        )
    );
    $objPHPExcel->getActiveSheet()->getStyle($cells)->applyFromArray(
        array(
            'font' => array('size' => 20),
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('rgb' => 'cccccc')
                )
            )

        )
    );
    $objPHPExcel->getActiveSheet()->getStyle($cells)->getFont()->setSize(18);
}
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>桂田技術顧問訂單管理系統</title>
    <link href="./css/common.css?id=<?php echo rand(0, 10000); ?>" rel="stylesheet">
</head>

<body>
    <div class="bgBody">
        <?php include("./module/header.php"); ?>
        <div class="container">
            <?php include("./module/menu.php"); ?>
            <div class="mainContent">
                <div class="head">
                    <div class="item title">下載報表</div>
                    <div class="clear"></div>
                </div>
                <div style="margin:1.3em;"><a href="reports/<?php echo $orderID; ?>.xlsx">下載Excel報表</a></a>
                    <form action="mail.php?id=<?php echo $_REQUEST['id']; ?>" method="post">
                        <div style="float:left;">寄出報表至: <input type="text" name="email" id="email"
                                value="ktienwang@gmail.com"></div>
                        <div class="input"><input type="submit" value="寄出" style="margin-left:1em;"><input type="hidden"
                                name="orderID" value="<?php echo $fileName; ?>"></div>
                    </form>
                    <div class="clear"></div>
                </div>
            </div>
        </div>
</body>

</html>



<?php
/*
   //欄,列
   $objPHPExcel->getActiveSheet()->setCellValue('A1', "訂單資訊");
   //第二列
   $objPHPExcel->getActiveSheet()->setCellValue('A2', "訂單編號");
   $objPHPExcel->getActiveSheet()->getCell("B2")->setValueExplicit($orderInfo[0]['orderID'], PHPExcel_Cell_DataType::TYPE_STRING);
   $objPHPExcel->getActiveSheet()->setCellValue('C2', "試驗日期");
   $objPHPExcel->getActiveSheet()->getCell("D2")->setValueExplicit($orderInfo[0]['testDate'], PHPExcel_Cell_DataType::TYPE_STRING);
   $objPHPExcel->getActiveSheet()->setCellValue('E2', "工程名稱");
   $objPHPExcel->getActiveSheet()->getCell("F2")->setValueExplicit($orderInfo[0]['projectName'], PHPExcel_Cell_DataType::TYPE_STRING);
   //第三列
   $objPHPExcel->getActiveSheet()->setCellValue('A3', "委託單位");
   $objPHPExcel->getActiveSheet()->getCell("B3")->setValueExplicit($orderInfo[0]['applicantName'], PHPExcel_Cell_DataType::TYPE_STRING);
   $objPHPExcel->getActiveSheet()->setCellValue('C3', "業主");
   $objPHPExcel->getActiveSheet()->getCell("D3")->setValueExplicit($orderInfo[0]['businessOwner'], PHPExcel_Cell_DataType::TYPE_STRING);
   $objPHPExcel->getActiveSheet()->setCellValue('E3', "監造單位");
   $objPHPExcel->getActiveSheet()->getCell("F3")->setValueExplicit($orderInfo[0]['supervisor'], PHPExcel_Cell_DataType::TYPE_STRING);
   //第四列
   $objPHPExcel->getActiveSheet()->setCellValue('A4', "承包商");
   $objPHPExcel->getActiveSheet()->getCell("B4")->setValueExplicit($orderInfo[0]['contractor'], PHPExcel_Cell_DataType::TYPE_STRING);
   $objPHPExcel->getActiveSheet()->setCellValue('C4', "結構部位");
   $objPHPExcel->getActiveSheet()->getCell("D4")->setValueExplicit($orderInfo[0]['structuralPart'], PHPExcel_Cell_DataType::TYPE_STRING);
   $objPHPExcel->getActiveSheet()->setCellValue('E4', "製作日期");
   $objPHPExcel->getActiveSheet()->getCell("F4")->setValueExplicit($orderInfo[0]['productionDate'], PHPExcel_Cell_DataType::TYPE_STRING);
   //第五列
   $objPHPExcel->getActiveSheet()->setCellValue('A5', "受測材料");
   $objPHPExcel->getActiveSheet()->getCell("B5")->setValueExplicit($orderInfo[0]['testedMaterial'], PHPExcel_Cell_DataType::TYPE_STRING);
   $objPHPExcel->getActiveSheet()->setCellValue('C5', "天氣");
   $objPHPExcel->getActiveSheet()->getCell("D5")->setValueExplicit($orderInfo[0]['weather'], PHPExcel_Cell_DataType::TYPE_STRING);
   $objPHPExcel->getActiveSheet()->setCellValue('E5', "使用材料");
   $objPHPExcel->getActiveSheet()->getCell("F5")->setValueExplicit($orderInfo[0]['materialsUsed'], PHPExcel_Cell_DataType::TYPE_STRING);
   //第6列
   $objPHPExcel->getActiveSheet()->setCellValue('A6', "表面溫度");
   $objPHPExcel->getActiveSheet()->getCell("B6")->setValueExplicit($orderInfo[0]['surfaceTemp'], PHPExcel_Cell_DataType::TYPE_STRING);
   $objPHPExcel->getActiveSheet()->setCellValue('C6', "使用設備");
   $objPHPExcel->getActiveSheet()->getCell("D6")->setValueExplicit($orderInfo[0]['equipUsed'], PHPExcel_Cell_DataType::TYPE_STRING);
   $objPHPExcel->getActiveSheet()->setCellValue('E6', "材料名稱");
   $objPHPExcel->getActiveSheet()->getCell("F6")->setValueExplicit($orderInfo[0]['materialsName'], PHPExcel_Cell_DataType::TYPE_STRING);
   //第7列
   $objPHPExcel->getActiveSheet()->setCellValue('A7', "備註");
   $objPHPExcel->getActiveSheet()->getCell("B7")->setValueExplicit($orderInfo[0]['remark'], PHPExcel_Cell_DataType::TYPE_STRING);
   //第8列
   $objPHPExcel->getActiveSheet()->setCellValue('A8', "請款資料:公司名稱");
   $objPHPExcel->getActiveSheet()->getCell("B8")->setValueExplicit($orderInfo[0]['paymentCompany'], PHPExcel_Cell_DataType::TYPE_STRING);
   $objPHPExcel->getActiveSheet()->setCellValue('C8', "請款資料:公司統編");
   $objPHPExcel->getActiveSheet()->getCell("D8")->setValueExplicit($orderInfo[0]['paymentTax'], PHPExcel_Cell_DataType::TYPE_STRING);
   $objPHPExcel->getActiveSheet()->setCellValue('E8', "請款資料:公司地址");
   $objPHPExcel->getActiveSheet()->getCell("F8")->setValueExplicit($orderInfo[0]['paymentAddr'], PHPExcel_Cell_DataType::TYPE_STRING);
   //第9列
   $objPHPExcel->getActiveSheet()->setCellValue('A9', "請款資料:連絡電話");
   $objPHPExcel->getActiveSheet()->getCell("B9")->setValueExplicit($orderInfo[0]['paymentPhone'], PHPExcel_Cell_DataType::TYPE_STRING);
   $objPHPExcel->getActiveSheet()->setCellValue('C9', "請款資料:測試費用");
   $objPHPExcel->getActiveSheet()->getCell("D9")->setValueExplicit($orderInfo[0]['paymentFee'], PHPExcel_Cell_DataType::TYPE_STRING);
   
   //測試項目抓15
   $objPHPExcel->getActiveSheet()->setCellValue('A12', "項目編號");
   $objPHPExcel->getActiveSheet()->setCellValue('A13', "測試位置/樣品名稱");
   $objPHPExcel->getActiveSheet()->setCellValue('A14', "製作日期");
   $objPHPExcel->getActiveSheet()->setCellValue('A15', "抗拉荷重kN");
   $objPHPExcel->getActiveSheet()->setCellValue('A16', "抗拉荷重kgf");
   $objPHPExcel->getActiveSheet()->setCellValue('A17', "長度");
   $objPHPExcel->getActiveSheet()->setCellValue('A18', "寬度");
   $objPHPExcel->getActiveSheet()->setCellValue('A19', "面積");
   $objPHPExcel->getActiveSheet()->setCellValue('A20', "強度kgf");
   $objPHPExcel->getActiveSheet()->setCellValue('A21', "強度MPa");
   $objPHPExcel->getActiveSheet()->setCellValue('A22', "破壞位置");
   $objPHPExcel->getActiveSheet()->setCellValue('A23', "破壞模式");
   $collums=array("B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q");
   $j=0;
   for($i=0;$i<count($testItems);$i++){
       $objPHPExcel->getActiveSheet()->getCell($collums[$j]."12")->setValueExplicit($testItems[$i]['serialNum'], PHPExcel_Cell_DataType::TYPE_STRING);
       $objPHPExcel->getActiveSheet()->getCell($collums[$j]."13")->setValueExplicit($testItems[$i]['testLocat'], PHPExcel_Cell_DataType::TYPE_STRING);
       $objPHPExcel->getActiveSheet()->getCell($collums[$j]."14")->setValueExplicit($testItems[$i]['productionDate'], PHPExcel_Cell_DataType::TYPE_STRING);
       $objPHPExcel->getActiveSheet()->getCell($collums[$j]."15")->setValueExplicit($testItems[$i]['kN'], PHPExcel_Cell_DataType::TYPE_STRING);
       $objPHPExcel->getActiveSheet()->getCell($collums[$j]."16")->setValueExplicit($testItems[$i]['kgf'], PHPExcel_Cell_DataType::TYPE_STRING);
       $objPHPExcel->getActiveSheet()->getCell($collums[$j]."17")->setValueExplicit($testItems[$i]['length'], PHPExcel_Cell_DataType::TYPE_STRING);
       $objPHPExcel->getActiveSheet()->getCell($collums[$j]."18")->setValueExplicit($testItems[$i]['width'], PHPExcel_Cell_DataType::TYPE_STRING);
       $objPHPExcel->getActiveSheet()->getCell($collums[$j]."19")->setValueExplicit($testItems[$i]['area'], PHPExcel_Cell_DataType::TYPE_STRING);
       $objPHPExcel->getActiveSheet()->getCell($collums[$j]."20")->setValueExplicit($testItems[$i]['strengthKGF'], PHPExcel_Cell_DataType::TYPE_STRING);
       $objPHPExcel->getActiveSheet()->getCell($collums[$j]."21")->setValueExplicit($testItems[$i]['strengthMPa'], PHPExcel_Cell_DataType::TYPE_STRING);
       $objPHPExcel->getActiveSheet()->getCell($collums[$j]."22")->setValueExplicit($testItems[$i]['destructionLocat'], PHPExcel_Cell_DataType::TYPE_STRING);
       $objPHPExcel->getActiveSheet()->getCell($collums[$j]."23")->setValueExplicit($testItems[$i]['destructionMode'], PHPExcel_Cell_DataType::TYPE_STRING);
       $j=$j+1;
   }
   
   //第25列
   $objPHPExcel->getActiveSheet()->setCellValue('A25', "取樣人員");
   if($orderInfo[0]['sampler']!=""){
       $objPHPExcel->getActiveSheet()->getCell("B25")->setValueExplicit($orderInfo[0]['sampler'], PHPExcel_Cell_DataType::TYPE_STRING);
   }
   
   //第26-31列
   $collums=array("A","B","C","D","E","F","G","H","I","J","K","L","M","N");
   $j=0;
   if(count($signs0)>0){ 
       for($i=0;$i<count($signs0);$i++){
          
           if(filesize("../signPics/".$signs0[$i]['picName'])>200){
               
               setImage($objPHPExcel,$signs0[$i]['picName'],$collums[$j]."26");
               $j=$j+1;
           }
       }
   }
   
   //第32列
   $objPHPExcel->getActiveSheet()->setCellValue('A32', "會驗人員");
   if($orderInfo[0]['examinator']!=""){
   $objPHPExcel->getActiveSheet()->getCell("B32")->setValueExplicit($orderInfo[0]['examinator'], PHPExcel_Cell_DataType::TYPE_STRING);
   }
   //第33-38列
   $collums=array("A","B","C","D","E","F","G","H","I","J","K","L","M","N");
   $j=0;
   if(count($signs1)>0){  
   for($i=0;$i<count($signs1);$i++){
       if(filesize("../signPics/".$signs1[$i]['picName'])>200){
           setImage($objPHPExcel,$signs1[$i]['picName'],$collums[$j]."33");
           $j=$j+1;
       }
   }
   }
   
   //第39列
   $objPHPExcel->getActiveSheet()->setCellValue('A39', "聯絡人");
   $objPHPExcel->getActiveSheet()->getCell("B39")->setValueExplicit($orderInfo[0]['paymentContactor'], PHPExcel_Cell_DataType::TYPE_STRING);
   //第40-55列
   $collums=array("A","B","C","D","E","F","G","H","I","J","K","L","M","N");
   $j=0;
   if(count($signs2)>0){  
   for($i=0;$i<count($signs2);$i++){
       if(filesize("../signPics/".$signs2[$i]['picName'])>200){
           
           setImage($objPHPExcel,$signs2[$i]['picName'],$collums[$j]."40");
           $j=$j+1;
       }
   }
   }
   //第46列
   $objPHPExcel->getActiveSheet()->setCellValue('A46', "測試人員");
   if($orderInfo[0]['paymentContactor']!=""){
   $objPHPExcel->getActiveSheet()->getCell("B46")->setValueExplicit($orderInfo[0]['paymentContactor'], PHPExcel_Cell_DataType::TYPE_STRING);
   }
   //第47-3x列
   $collums=array("A","B","C","D","E","F","G","H","I","J","K","L","M","N");
   $j=0;
   if(count($signs3)>0){  
   for($i=0;$i<count($signs3);$i++){
       if(filesize("../signPics/".$signs3[$i]['picName'])>200){
           
           setImage($objPHPExcel,$signs3[$i]['picName'],$collums[$j]."47");
           $j=$j+1;
       }
   }
   }
   
   //setImage($objPHPExcel);
   //設定樣式
   $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(24);
   $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(24);
   $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(24);
   $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(24);
   $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(24);
   $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(24);
   $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(24);
   $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(24);
   $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(24);
   $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(24);
   $grayCells=array("A2","C2","E2","A3","C3","E3","A4","C4","E4","A5","C5","E5","A6","C6","E6","A7","A8","C8","E8","A9","C9","A17","A12","A13","A14","A15","A16","A17","A18","A19","A20","A21","A22","A23","A25","A32","A39","A46");
   foreach($grayCells as $cell){
       cellColor($cell, 'e6e6e6');
   }
   

   $styleArray = array(
       'font'  => array(
            'size'  => 20
        ));      
   $objPHPExcel->getDefaultStyle()->applyFromArray($styleArray);
   */
?>