<?php
// ini_set('display_errors','1');
// error_reporting(E_ALL);
$page="equipment";
include("../function/func.php");
session_start();
checkSession();
$equipment_id = $_REQUEST['id'];
// 確認表單是否被提交
if($_SERVER['REQUEST_METHOD'] == 'POST') {
    // 確認 kgf 和 psi 是否設置並且是陣列
    if(isset($_POST['kgf']) && is_array($_POST['kgf']) && isset($_POST['psi']) && is_array($_POST['psi'])) {
        // 確認兩者大小相同
        if(count($_POST['kgf']) == count($_POST['psi'])) {
            // 遍歷所有的 kgf 和 psi 值
            for($i = 0; $i < count($_POST['kgf']); $i++) {
                // 使用這些值來呼叫你的函數
                addEquipmentInfo($_POST['equipment_id'],$_POST['psi'][$i], $_POST['kgf'][$i]);
            }
        } else {
            // 出錯：kgf 和 psi 的數量不相等
            echo "Error: the number of kgf and psi values are not the same.";
        }
    } else {
        // 出錯：kgf 和 psi 沒有設置或者不是陣列
        echo "Error: kgf and psi values are not set or are not arrays.";
    }
    if(isset($_POST['equipmentName'])){
        setEquipmentNameByID($equipment_id,$_POST['equipmentName']);
    }
    //header("refresh:1;url=updateEquipment.php");
}
$equipmentInfos = getEquipmentInfo($equipment_id);
$equipmentName = getEquipmentByID($equipment_id);
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>桂田技術顧問訂單管理系統</title>
    <link href="./css/common.css?id=<?php echo rand(0,10000);?>" rel="stylesheet">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
    <script src="https://code.jquery.com/jquery-3.6.0.js"></script>
    <script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
</head>
<body>
<div class="bgBody">
    <?php include("./module/header.php"); ?>
    <div class="container">
        <?php include("./module/menu.php"); ?>
        <div class="mainContent">
            <div class="head">
                <div class="itemtitle">新增設備</div>
                <a href="equipmentList.php?id=<?php echo $_REQUEST['id'];?>">
                    <div class="itemsearchInput" style="padding-top:0.3em">回設備列表</div>
                </a>
                <div class="clear"></div>
            </div>
            
            <div class="testItemList">
                <form action="updateEquipment.php?id=<?php echo $equipment_id;?>" method="post">
                <div class="testItem">
                    <div class="item">設備名稱 <input type="text" name="equipmentName" value="<?php echo $equipmentName?>" style="width: 60ch;"></div>
                    <div class="input"><input type="submit" value="修改名稱"></div>
                </div>
                </from>
                <form action="updateEquipment.php?id=<?php echo $equipment_id;?>" method="post">
                    <?php foreach($equipmentInfos as $item){ ?>
                    <div class="testItem gray">
                        
                        <div class="item">KGF <input type="text" name="kgf[]" value="<?php echo $item['kgf'];?>"></div>
                        <div class="item">PSI <input type="text" name="psi[]" value="<?php echo $item['psi'];?>"></div>
                        <div class="input"><button type="button" onclick="deleteItem(this, '<?php echo $item['id']; ?>')">刪除</button></div>
                    </div>
                    <?php } ?>
                    <div class="testItem gray">
                        
                        <div class="item">KGF <input type="text" name="kgf[]" value=""></div>
                        <div class="item">PSI <input type="text" name="psi[]" value=""></div>
                    </div>
                    <div id="extraFields"></div>
                    <div class="input"><input type="button" id="addField" value="新增一列資料"></div>
                    <!-- 增加一個隱藏欄位 id -->
                    <input type="hidden" name="equipment_id" value="<?php echo $equipment_id;?>">
                    <div class="input"><input type="submit" value="送出"></div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function(){
        var counter = 1;
        $('#addField').click(function(){
            $('#extraFields').append('<div class="testItem gray" id="field'+counter+'"><div class="item">KGF<input type="text" name="kgf[]" value=""></div><div class="item">PSI<input type="text" name="psi[]" value=""></div><div class="input"><input type="button" onclick="removeField('+counter+')" value="移除欄位"></div></div>');
            counter++;
        });
    });

    function removeField(id){
        $('#field'+id).remove();
    }
    function deleteItem(button, id) {
        $.ajax({
            url: 'deleteEquipmentInfo.php',
            type: 'POST',
            data: {
            'id': id
            },
            success: function(response) {
            // 如果刪除成功，從頁面中移除該項目
            if (response == 'success') {
                $(button).closest('.testItem.gray').remove();
            } else {
                // 如果刪除失敗，顯示錯誤信息
                alert('刪除失敗');
            }
            }
        });
        }
</script>
</body>
</html>
